Here’s a clean, copy-paste-ready **README.md** for your EduQuest Luanti (Minetest) mod.

---

# EduQuest (Luanti/Minetest Mod)

EduQuest adds lightweight, classroom-friendly learning features to Luanti/Minetest. The first module included is a **welcome quiz** (multiple-choice) that can be customized and optionally integrated with your own HTTPS backend for logging, personalization, or progression. Internally, the mod uses a tiny DI container to keep things modular and testable.&#x20;

## Highlights

* ✨ **Welcome quiz UI** (formspec) with customizable questions.
* 🌐 **Optional HTTPS integration** via Luanti’s `request_http_api` (respecting `secure.http_mods`).&#x20;
* 🧩 **Modular DI setup** (settings, HTTP helpers, services) for easy extension.&#x20;
* 🔧 **Pluggable services**: swap your repo/logger/service implementations without touching game logic.&#x20;

---

## Requirements

* Luanti/Minetest 5.4+ (tested with modern Luanti builds).
* To enable outbound HTTP (optional), allow the mod in `minetest.conf`:

  ```conf
  secure.http_mods = eduquest
  secure.trusted_mods = eduquest
  ```

---

## Installation

1. **Clone or copy** this repo into your world’s `mods/` directory as `eduquest/`.
2. **Enable** the mod for your world.
3. (Optional) **Allow HTTP** if you plan to call your backend (see above).

Directory snapshot (key files used by this module):

```
eduquest/
├─ init.lua
├─ app/
│  ├─ register.lua
│  └─ defaults.lua
├─ application/
│  └─ services/
│     └─ user_service.lua
├─ domain/
│  └─ models/
│     └─ user.lua
├─ infrastructure/
│  ├─ di/di.lua
│  ├─ http/http.lua
│  └─ settings/settings.lua
```

---

## Quick Start

By default, the mod registers the welcome quiz when it loads:

```lua
-- init.lua (excerpt)
local Registrar = dofile(MP .. "/app/register.lua")
Registrar.register_quiz(container, {
  formname = "welcome:quiz",
  -- questions = your_questions_table
})
```

This shows the form named `welcome:quiz` and uses either the built-ins or your custom questions if provided.&#x20;

### Customizing the Questions

Provide your own questions when calling `register_quiz`:

```lua
Registrar.register_quiz(container, {
  formname = "welcome:quiz",
  questions = {
    {
      text = "Which tool digs stone fastest?",
      answers = {
        { label = "Wooden shovel", correct = false },
        { label = "Stone pickaxe", correct = true },
        { label = "Steel axe",     correct = false },
      },
    },
    -- add more…
  },
})
```

Each `answers` entry needs a `label` and a boolean `correct`.

> Tip: If you’ve split registration into `app/register.lua`, keep your custom question set next to it or load it from a separate file, then pass it into `register_quiz`.

---

## Optional: Backend Integration

The mod resolves Luanti’s HTTP API from the DI container and exposes an HTTP helper module (e.g., for URL normalization, timeouts, tokens) so you can call your service when players complete questions. If `request_http_api()` is not permitted, the container still initializes cleanly—your gameplay won’t break; HTTP calls are simply unavailable.&#x20;

You can wire your own service inside `app/register.lua` or a separate service module and call it from the quiz callbacks (e.g., “on answer submit” → POST results).

---

## Configuration (suggested)

If you add a settings helper (already registered in DI), you can support values like:

* `eduquest_base_url` – your backend base URL
* `eduquest_endpoint` – path to your quiz endpoint
* `eduquest_token` – bearer or API token
* `eduquest_http_timeout` – request timeout (seconds)

These can be read via `minetest.settings` (already provided to the DI container) and combined in your HTTP helper (e.g., `normalize_url(base, endpoint)`) before you call `http.fetch`.&#x20;

---

## How it’s wired (for developers)

* **DI container**: `infrastructure/di/di.lua`. In `init.lua` we register:

  * `http`, `settings`, `http_api`, `settings_api`
  * simple `logger`, sample `repo`, and a `UserService` (as an example)
* **Services**: e.g., `application/services/user_service.lua` created with `{ repo, logger }`.
* **Registrar**: `app/register.lua` exposes `register_quiz(container, opts)` to hook forms, keybinds, and callbacks in one place.
* **Entry point**: `init.lua` composes everything and calls the registrar.&#x20;

Because everything is resolved from the container, you can swap implementations without touching UI or game logic (great for tests and for moving from prototypes to production backends).

---

## Troubleshooting

* **I don’t see network calls happening**

  * Ensure `secure.http_mods = eduquest` is set.
  * Check server logs on startup—`http_api` will be `nil` if not permitted.&#x20;
* **Form doesn’t appear**

  * Confirm `register_quiz` is called and `formname` is unique.
  * Temporarily log from the registrar to ensure the callbacks are registered.

---

## Roadmap

* Question banks from an external service
* Per-player progress tracking and rewards
* Instructor dashboards (web) + in-game hooks
* Accessibility improvements (fonts, dark mode presets)

---

## License

MIT

---

## Credits

* Built for EduQuest learning projects on Luanti/Minetest.
* Thanks to the Luanti/Minetest community for APIs and docs.

---
